<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.09.2024

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Identitäten');
requireLogin();
requireRole(['Bearbeiter', 'Administrator']);


include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Identitäten</h4>
        <span class="text-secondary">Dashboard</span>
    </div>
</div>

<div class="row">

    <div class="col-12 col-md-4 col-xl-3 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><span class="mdi mdi-briefcase me-2"></span> Dienstposten</h5>
                <p class="card-text mb-3">Verwalten Sie Dienstposten mit zugewiesenen Zonenberechtigungen für den
                    kontrollierten Zugang zu bestimmten Bereichen.</p>
            </div>
            <div class="card-footer">
                <div class="btn-group" role="group" aria-label="Dienstposten">
                    <a href="/identities/positions" class="btn btn-primary btn-icon-text">
                        <i class="btn-icon-prepend mdi mdi-open-in-new"></i>
                        Verwalten
                    </a>

                    <button class="btn btn-secondary btn-icon dropdown-toggle-split" type="button"
                        id="dropdownMenuPositions" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="mdi mdi-plus"></i>
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuPositions">
                        <a class="dropdown-item" href="/identities/add-position-military">Militärisch</a>
                        <a class="dropdown-item" href="/identities/add-position-civil">Zivil</a>
                        <a class="dropdown-item" href="/identities/add-position-local">Ortskräfte</a>
                        <a class="dropdown-item" href="/identities/add-position-guest">Gast</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-4 col-xl-3 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><span class="mdi mdi-account-group me-2"></span> Identitäten</h5>
                <p class="card-text mb-3">Hier können Sie Soldaten, Zivilisten und Ortskräfte verwalten, hinzufügen und
                    einem Dienstposten zuweisen.</p>
            </div>
            <div class="card-footer">
                <div class="btn-group" role="group" aria-label="Identitäten">
                    <a href="/identities/identities" class="btn btn-primary btn-icon-text">
                        <i class="btn-icon-prepend mdi mdi-open-in-new"></i>
                        Verwalten
                    </a>

                    <button class="btn btn-secondary btn-icon dropdown-toggle-split" type="button"
                        id="dropdownMenuPositions" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="mdi mdi-plus"></i>
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuPositions">
                        <a class="dropdown-item" href="/identities/add-identity-military">Soldat</a>
                        <a class="dropdown-item" href="/identities/add-identity-civil">Zivilist</a>
                        <a class="dropdown-item" href="/identities/add-identity-local">Ortskraft</a>
                        <a class="dropdown-item" href="/identities/add-identity-guest">Gast</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-4 col-xl-3 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><span class="mdi mdi mdi-folder-search-outline me-2"></span> Schnellwahl</h5>
                <p class="card-text mb-3">Hier haben Sie über die Schnellwahl direkten Zugriff auf alle Zutrittskarten,
                    Dienstposten und Identitäten.</p>
                <p><span style="font-size:10px;" class="text-warning">NICHT VERFÜGBAR</span></p>
            </div>
            <div class="card-footer">
                <select class="js-example-basic-single form-select form-control" name="schnellwahl" data-width="100%">
                    <option>Eingabe</option>

                    <?php

                    // Datenbankverbindung
                    initializeDatabaseConnection();

                    $sql = "SELECT * FROM Positions";
                    $stmt = $pdo->query($sql);
                    $AccessCards = $stmt->fetchAll();

                    if ($AccessCards) {
                        foreach ($AccessCards as $AccessCard) {
                            echo '<option>Dienstposten | ' . $AccessCard['ID'] . ', ' . $AccessCard['Department'] . ', ' . $AccessCard['PositionName'] . '</option>';
                        }
                    }

                    $sql = "SELECT * FROM Identities";
                    $stmt = $pdo->query($sql);
                    $AccessCards = $stmt->fetchAll();

                    if ($AccessCards) {
                        foreach ($AccessCards as $AccessCard) {
                            echo '<option>Identität | ' . $AccessCard['Surname'] . ', ' . $AccessCard['Givenname'] . '</option>';
                        }
                    }

                    ?>

                </select>
            </div>
        </div>
    </div>


</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>